<?php
#
# Script         oem_finance
# Copyright      2007 OEM Scripts
# Autor          Denny Schlesinger
# OEM Scripts    http://oemscripts.com
#
# $Id:
#

/*******************   oem_finance  *******************
*
* class Finance
*       Base class not used by itself
*
* function fv(rate,nper,pmt[,pv[,type]]) OK
*       Returns the future value of an investment
*
* function fva(rate,nper,pmt[,type]) OK
*       Returns the future value of an annuity
*
* function irr(values,guess) OK
*       Returns the internal rate of return of an investment
*
* function mirr(values,finance_rate,reinvest_rate)
*       Returns the modified internal rate of return of an investment
*
* function nper(rate,pmt,pv,fv,type) OK
*       Returns the number of periods of an investment
*
* function npv(rate,values) OK
*       Returns the net present value of an investment
*
* function pmt(rate,nper,pv[,fv[,type]]) OK
*       Returns the payments on a purchase
*
* function pv(rate,nper,pmt[,fv[,type]]) OK
*       Returns the present value of an investment
*
* function pva(rate,nper,pmt[,type]) OK
*       Returns the present value of an annuity
*
* function rate(nper,pmt,pv,fv,type,guess)  OK if pmt == 0
*       Returns the required interest rate
*
* function xirr(values[,guess]) OK
*       Returns the internal rate of return of a cash flow
*
*
* Author:    Denny Schlesinger
* Copyright: 2007 by Denny Schlesinger
*
* Thanks to GetObjects.com for the help with the formulas
* http://www.getobjects.com/
*
*******************************************************/


class Finance {
    var $values = array();
    var $dates  = array();
    var $guess;
    var $fv;
    var $fva;
    var $rate;
    var $reinvest_rate;
    var $nper;
    var $pmt;
    var $pv;
    var $type;
    
    function Finance() {
    }

    function printer() {
        print_r ($this->values);
        echo "<br>\n<br>\n";
        echo "my_guess= " . $this->my_guess . "<br>\n";
    }

    function _years($date1, $date2) {
        $temp = explode ('-', $date1);
        $time1 = mktime (0, 0, 0, $temp[1], $temp[2], $temp[0]);
        $temp = explode ('-', $date2);
        $time2 = mktime (0, 0, 0, $temp[1], $temp[2], $temp[0]);
        $years = ($time2 - $time1) / 60/60/24/365;
        return $years;
    }

    function fv($rate, $nper, $pmt, $pv = 0, $type = 0) {
        $fv  = Finance::fva($rate, $nper, $pmt, $type);
        // FV = PV (1 + i)n
        $fv -= $pv * pow ((1 + $rate), $nper);
        return $fv;
    }

    function fva($rate, $nper, $pmt, $type = 0) {
        // PMT [((1 + i)n - 1) / i]
        $fva = - ($pmt * ((pow ((1 + $rate), $nper) - 1) / $rate));
        if ($type == 1) { $fva = $fva * (1 + $rate); }
        return $fva;
        
    }
    
    function irr(&$values, $guess = 1) {
        $limit    = .00001;
        $maxLoops = 40;
        $delta    = 1;                    // to get into the loop
        $interval = $guess;
        $switch   = 1;

        while (abs ($delta) > $limit AND $maxLoops-- > 0) {
            $delta = 0;                  // clear delta
            
            // calculate delta
            $i = 0;
            foreach ($values AS $value) {
                $delta += -Finance::pv($guess, $i++, 0, $value);
            } // calculate delta
   //         $delta = abs ($delta);
//echo "delta= " . $delta . " - ";
//echo "guess= " . $guess . "<br>\n";
            
            // adjust guess
            if ($delta > $limit) {
//echo "kilroy was here <br>\n";
                if ($switch == 1) {
                    $interval *= 2;         // double the interval
                } else {
                    $interval /= $switch;   // reduce by 50%
                }
                $guess += $interval;
            } elseif ($delta < -$limit) {
                $switch = 2;                // set switch to reduce
                $interval /= $switch;       // reduce by 50%
                $guess -= $interval;
            } // adjust guess
            
        } // while (abs ($delta) > $limit AND $maxLoops-- > 0)

        if (abs ($delta) > $limit) { return FALSE; }
        return $guess;
    }

    function mirr($values, $finance_rate, $reinvest_rate) {
        return "#FUNCTION NOT CODED";
        return $mirr;
    }

    function nper($rate, $pmt, $pv, $fv = 0, $type = 0) {
        if ($rate == 0) { return "#NUM"; }

        if ($pmt == 0) {
            // number of periods = natural log [(FV * i) / (PV * i)] / natural log (1 + i)
            $nper = log (($fv * $rate) / (-$pv * $rate)) / log (1 + $rate);
        } else {
            if ($type != 0) { $type = 1; }
            $nper = log(($pmt * (1 + $rate * $type) / $rate - $fv) / ($pv + $pmt * (1 + $rate * $type) / $rate)) / log(1 + $rate);
        }
        
        if (ctype_digit($nper)) { return $nper; }
        return "#NUM";

    }

    function npv($rate, &$values) {
        $npv  = 0;
        $nper = 1;
        foreach ($values AS $value) {
            $npv += Finance::pv($rate, $nper++, 0, $value);
        }
        return $npv;
    }

    function pmt($rate, $nper, $pv, $fv = 0, $type = 0) {
        // adjust for future value
        if ($fv != 0) { 
            $pv = $pv + Finance::pv($rate, $nper, 0, $fv, $type);
        }
        // adjust for type
        if ($type == 1) { $pv = $pv * 1 / (1 + $rate); }
        // payment = PVoa / [(1- (1 / (1 + i)n )) / i]
        $pmt = $pv / ((1 - (1 / pow ((1 + $rate), $nper) )) / $rate);
        return $pmt;
    }

    function pv($rate, $nper, $pmt, $fv = 0, $type = 0) {
        if ($rate == 0) {
            $pv = - ($nper * $pmt + $fv);
            return $pv;
        }
        $pv  = Finance::pva($rate, $nper, $pmt, $type);
        // PV = FV [ 1 / (1 + i)n ]
        $pv -= $fv * (1 / pow ((1 + $rate), $nper));
        return $pv;
    }

    function pva($rate, $nper, $pmt, $type = 0) {
        // PMT [(1 - (1 / (1 + i)n)) / i]
        $pva = - ($pmt * ((1 - (1 / pow ((1 + $rate), $nper) )) / $rate));
        if ($type == 1) { $pva = $pva * (1 + $rate); }
        return $pva;
    }

    function rate($nper, $pmt, $pv, $fv = 0, $type = 0, $guess = .1) {
        if ($nper == 0 OR $pv == 0) { return "#NUM"; }
        if ($pmt == 0 AND $fv != 0) {
            // i = ( FV / PV) (1/n) -1
            $rate = pow ($fv / $pv, 1 / $nper) - 1;
            return $rate;
        } else {
            // given $nper, $pmt, $pv,
            // iterate
            return "#FUNCTION NOT CODED";
            return $rate;
        }

    }

    function xirr(&$values, $guess = 1) {
        $limit    = .00001;
        $maxLoops = 40;
        $date     = $values[0][1];        // target date
        $delta    = 1;                    // to get into the loop
        $interval = $guess;
        $switch   = 1;

        while (abs ($delta) > $limit AND $maxLoops-- > 0) {
            $delta = 0;                  // clear delta
            
            // calculate delta
            foreach ($values AS $value) {
                $years = Finance::_years($date, $value[1]);
                $delta += Finance::pv($guess, $years, 0, $value[0]);
            } // calculate delta
            
            // adjust guess
            if ($delta > $limit) {
                if ($switch == 1) {
                    $interval *= 2;         // double the interval
                } else {
                    $interval /= $switch;   // reduce by 50%
                }
                $guess += $interval;
            } elseif ($delta < -$limit) {
                $switch = 2;                // set switch to reduce
                $interval /= $switch;       // reduce by 50%
                $guess -= $interval;
            } // adjust guess
            
        } // while (abs ($delta) > $limit AND $maxLoops-- > 0)

        if (abs ($delta) > $limit) { return FALSE; }
        return $guess;
        
    } //function xirr(&$values, $guess = 1)

}

?>
